/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.crops;

import cloud.lemonslice.teastory.block.crops.AqueductBlock;
import cloud.lemonslice.teastory.block.crops.PaddyFieldBlock;
import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LowAqueductBlock
extends AqueductBlock {
    protected static VoxelShape[] SHAPES;

    public LowAqueductBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)BLOCKED)).booleanValue()) {
            return FULL_SHAPE;
        }
        int bottom = (Boolean)state.m_61143_((Property)BOTTOM) != false ? 0 : 16;
        int north = (Boolean)state.m_61143_((Property)NORTH) != false ? 0 : 8;
        int south = (Boolean)state.m_61143_((Property)SOUTH) != false ? 0 : 4;
        int west = (Boolean)state.m_61143_((Property)WEST) != false ? 0 : 2;
        int east = (Boolean)state.m_61143_((Property)EAST) != false ? 0 : 1;
        return SHAPES[bottom + north + south + west + east];
    }

    @Override
    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        boolean flag = false;
        int nearDistance = this.getNearDistance(level, pos);
        int currentDistance = (Integer)state.m_61143_((Property)DISTANCE);
        if (((Boolean)state.m_61143_((Property)BLOCKED)).booleanValue()) {
            return;
        }
        int lost = new Random(pos.m_121878_() + level.m_7328_()).nextInt(1) + 5;
        if (nearDistance + 1 < currentDistance) {
            state = (BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(Math.min(nearDistance + lost, 31)));
            level.m_186460_(pos, (Block)this, Fluids.f_76193_.m_6718_((LevelReader)level));
            this.updateConnected(level, pos, state);
            flag = true;
        } else if (nearDistance + 1 != currentDistance) {
            state = (BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(32));
            this.updateConnected(level, pos, state);
            flag = true;
        }
        if (flag) {
            level.m_46597_(pos, state);
            this.updateWater(level, pos, state);
        }
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!(facingState.m_60734_() instanceof AqueductBlock) && !(facingState.m_60734_() instanceof PaddyFieldBlock)) {
            level.m_186460_(currentPos, (Block)this, Fluids.f_76193_.m_6718_((LevelReader)level) / 2);
        }
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186460_(currentPos, (Block)this, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (facing.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL) {
            stateIn = (BlockState)stateIn.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.canConnect(facingState)));
        } else if (facing == Direction.DOWN) {
            stateIn = (BlockState)stateIn.m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(LowAqueductBlock.isAqueduct(facingState)));
        }
        return stateIn;
    }

    @Override
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_75953_(8, false) : super.m_5888_(state);
    }

    static {
        VoxelShape POST_0 = VoxelShapeHelper.createVoxelShape(0.0, 4.0, 0.0, 4.0, 11.0, 4.0);
        VoxelShape POST_1 = VoxelShapeHelper.createVoxelShape(12.0, 4.0, 0.0, 4.0, 11.0, 4.0);
        VoxelShape POST_2 = VoxelShapeHelper.createVoxelShape(0.0, 4.0, 12.0, 4.0, 11.0, 4.0);
        VoxelShape POST_3 = VoxelShapeHelper.createVoxelShape(12.0, 4.0, 12.0, 4.0, 11.0, 4.0);
        VoxelShape BOTTOM = VoxelShapeHelper.createVoxelShape(0.0, 0.0, 0.0, 16.0, 4.0, 16.0);
        VoxelShape BOTTOM_OPTIONAL = VoxelShapeHelper.createVoxelShape(4.0, 0.0, 4.0, 8.0, 4.0, 8.0);
        VoxelShape DEFAULT = Shapes.m_83124_((VoxelShape)POST_0, (VoxelShape[])new VoxelShape[]{POST_1, POST_2, POST_3, Shapes.m_83113_((VoxelShape)BOTTOM, (VoxelShape)BOTTOM_OPTIONAL, (BooleanOp)BooleanOp.f_82685_)});
        VoxelShape WALL_NORTH = VoxelShapeHelper.createVoxelShape(4.0, 4.0, 0.0, 8.0, 11.0, 4.0);
        VoxelShape WALL_SOUTH = VoxelShapeHelper.createVoxelShape(4.0, 4.0, 12.0, 8.0, 11.0, 4.0);
        VoxelShape WALL_WEST = VoxelShapeHelper.createVoxelShape(0.0, 4.0, 4.0, 4.0, 11.0, 8.0);
        VoxelShape WALL_EAST = VoxelShapeHelper.createVoxelShape(12.0, 4.0, 4.0, 4.0, 11.0, 8.0);
        SHAPES = new VoxelShape[]{DEFAULT, Shapes.m_83110_((VoxelShape)DEFAULT, (VoxelShape)WALL_EAST).m_83296_(), Shapes.m_83110_((VoxelShape)DEFAULT, (VoxelShape)WALL_WEST).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST}).m_83296_(), Shapes.m_83110_((VoxelShape)DEFAULT, (VoxelShape)WALL_SOUTH).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_EAST, WALL_SOUTH}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_SOUTH}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST, WALL_SOUTH}).m_83296_(), Shapes.m_83110_((VoxelShape)DEFAULT, (VoxelShape)WALL_NORTH).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_EAST, WALL_NORTH}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_NORTH}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST, WALL_NORTH}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_SOUTH, WALL_NORTH}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_EAST, WALL_SOUTH, WALL_NORTH}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_SOUTH, WALL_NORTH}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST, WALL_SOUTH, WALL_NORTH}).m_83296_(), Shapes.m_83110_((VoxelShape)DEFAULT, (VoxelShape)BOTTOM_OPTIONAL).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_EAST, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_SOUTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_EAST, WALL_SOUTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_SOUTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST, WALL_SOUTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_NORTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_EAST, WALL_NORTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_NORTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST, WALL_NORTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_SOUTH, WALL_NORTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_EAST, WALL_SOUTH, WALL_NORTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_SOUTH, WALL_NORTH, BOTTOM_OPTIONAL}).m_83296_(), Shapes.m_83124_((VoxelShape)DEFAULT, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST, WALL_SOUTH, WALL_NORTH, BOTTOM_OPTIONAL}).m_83296_()};
    }
}

